/****************************************************************************/
/* File: tuner_settings.h                                                   */
/* Author: Gary M. Segal                                                    */
/* Copyright (C) 2006, Freescale Semiconductor, INC                         */
/****************************************************************************/
/* Description:						                                        */
/*   This file contains the external defintion for the tuner settings table */
/*                                                                          */
/****************************************************************************/
/* revision history:                                                        */
/*                                                                          */
/* Date      Version  Comments                                      Initial */
/* ------------------------------------------------------------------------ */
/* 05/24/06  1.0      Created                                       gms     */
/*                                                                          */
/****************************************************************************/

extern TUNER_SETTINGS_T g_tuner_settings_table[];

extern int g_nominal_if;
extern int g_ref_freq;
extern int g_if_out;

/* The following entries define the target windows for the RF & IF power    */
/* detectors.  These values are used by the AGC control loop.  The power    */
/* detectors return gray coded results, which are converted to linear values*/
/* in the agc routine.  The values below are integer values.  The conversion*/
/* table is located in tuner_globals.c.  It is repeated in these comments   */
/* to allow the user to easily adjust the target windows while reading the  */
/* values in the tuner data sheet.                                          */
/*                                                                          */
/* Gray Code   Linear
/* ------------------
/*       4       7
/*       5       6
/*       7       5
/*       6       4
/*       2       3
/*       3       2
/*       1       1
/*       0       0
*/ 

/* Note, these are linear values */
#define RF_PWR_MAX 5  /* gray code 7 */
#define RF_PWR_MIN 2  /* gray code 3 */

#define IF_PWR_MAX 5  /* gray code 7 */
#define IF_PWR_MIN 0  /* gray code 0 */

#define NUM_DETECTOR_AVG	5	/* Number of times to read detectors */

